using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class SStaff_SStaffDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public SStaff_SStaffDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public SStaff_SStaff GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 Provider_ID)
        {
            SStaff_SStaff objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_SStaff_SStaff_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, Provider_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        //public List<SStaff_SStaff> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION, int START_ROW, int MAX_ROWS)
        public List<SStaff_SStaff> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<SStaff_SStaff> objReturn = null;
            List<SStaff_SStaff_Complete> objTemp = null;

            //TODO: Cleanup and make more efficient

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    //objTemp = dbContext.usp_SStaff_SStaff_getitemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT, SORT_EXPRESSION, START_ROW, MAX_ROWS).ToList();
                    objTemp = dbContext.usp_SStaff_SStaff_getitemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    if (objTemp != null)
                    {
                        objReturn = new List<SStaff_SStaff>();

                        foreach (SStaff_SStaff_Complete ss in objTemp)
                        {
                            SStaff_SStaff staff = new SStaff_SStaff
                            {
                                City = ss.SStaff_SStaff_City,
                                CommercialPhone = ss.SStaff_SStaff_CommercialPhone,
                                CreatedByStaffSID = ss.SStaff_SStaff_CreatedByStaffSID,
                                DEA = ss.SStaff_SStaff_DEA,
                                Degree = ss.SStaff_SStaff_Degree,
                                DelegateOfStaffIEN = ss.SStaff_SStaff_DelegateOfStaffIEN,
                                DelegateOfStaffSID = ss.SStaff_SStaff_DelegateOfStaffSID,
                                DelegationDate = ss.SStaff_SStaff_DelegationDate,
                                DelegationLevel = ss.SStaff_SStaff_DelegationLevel,
                                DigitalPager = ss.SStaff_SStaff_DigitalPager,
                                ElectronicSignatureCodeFlag = ss.SStaff_SStaff_ElectronicSignatureCodeFlag,
                                EmailAddress = ss.SStaff_SStaff_EmailAddress,
                                EnteredDate = ss.SStaff_SStaff_EnteredDate,
                                ETLBatchID = ss.SStaff_SStaff_ETLBatchID,
                                FaxNumber = ss.SStaff_SStaff_FaxNumber,
                                FirstName = ss.SStaff_SStaff_FirstName,
                                Gender = ss.SStaff_SStaff_Gender,
                                HINQEmployeeNumberFlag = ss.SStaff_SStaff_HINQEmployeeNumberFlag,
                                HomePhone = ss.SStaff_SStaff_HomePhone,
                                InactivationDate = ss.SStaff_SStaff_InactivationDate,
                                LastEditedDateTime = ss.SStaff_SStaff_LastEditedDateTime,
                                LastName = ss.SStaff_SStaff_LastName,
                                LastSignonDateTime = ss.SStaff_SStaff_LastSignonDateTime,
                                LastUsedTerminalType = ss.SStaff_SStaff_LastUsedTerminalType,
                                MailCode = ss.SStaff_SStaff_MailCode,
                                MiddleName = ss.SStaff_SStaff_MiddleName,
                                NetworkUsername = ss.SStaff_SStaff_NetworkUsername,
                                NPI = ss.SStaff_SStaff_NPI,
                                NPIAuthorizedReleaseFlag = ss.SStaff_SStaff_NPIAuthorizedReleaseFlag,
                                OfficePhone = ss.SStaff_SStaff_OfficePhone,
                                OpCode = ss.SStaff_SStaff_OpCode,
                                PACFlag = ss.SStaff_SStaff_PACFlag,
                                Phone3 = ss.SStaff_SStaff_Phone3,
                                Phone4 = ss.SStaff_SStaff_Phone4,
                                PositionTitle = ss.SStaff_SStaff_PositionTitle,
                                Provider_ID = ss.SStaff_SStaff_Provider_ID,
                                ProviderClass = ss.SStaff_SStaff_ProviderClass,
                                ProviderClassSID = ss.SStaff_SStaff_ProviderClassSID,
                                ProviderScheduleType = ss.SStaff_SStaff_ProviderScheduleType,
                                Room = ss.SStaff_SStaff_Room,
                                ServiceComputationDate = ss.SStaff_SStaff_ServiceComputationDate,
                                ServiceSection = ss.SStaff_SStaff_ServiceSection,
                                ServiceSectionSID = ss.SStaff_SStaff_ServiceSectionSID,
                                ServiceType = ss.SStaff_SStaff_ServiceType,
                                SignatureBlockName = ss.SStaff_SStaff_SignatureBlockName,
                                SignatureBlockTitle = ss.SStaff_SStaff_SignatureBlockTitle,
                                SocialWorkerImmediateSupervisorStaffSID = ss.SStaff_SStaff_SocialWorkerImmediateSupervisorStaffSID,
                                SocialWorkerPositionTitle = ss.SStaff_SStaff_SocialWorkerPositionTitle,
                                Sta3n = ss.SStaff_SStaff_Sta3n,
                                StaffIEN = ss.SStaff_SStaff_StaffIEN,
                                StaffName = ss.SStaff_SStaff_StaffName,
                                StaffNamePrefix = ss.SStaff_SStaff_StaffNamePrefix,
                                StaffNameSuffix = ss.SStaff_SStaff_StaffNameSuffix,
                                StaffSID = ss.SStaff_SStaff_StaffSID,
                                StateName = ss.SStaff_SStaff_StateName,
                                StreetAddress1 = ss.SStaff_SStaff_StreetAddress1,
                                StreetAddress2 = ss.SStaff_SStaff_StreetAddress2,
                                StreetAddress3 = ss.SStaff_SStaff_StreetAddress3,
                                SupplyEmployee = ss.SStaff_SStaff_SupplyEmployee,
                                TemporaryAddress1 = ss.SStaff_SStaff_TemporaryAddress1,
                                TemporaryAddress2 = ss.SStaff_SStaff_TemporaryAddress2,
                                TemporaryAddress3 = ss.SStaff_SStaff_TemporaryAddress3,
                                TemporaryAddressEndDate = ss.SStaff_SStaff_TemporaryAddressEndDate,
                                TemporaryAddressStartDate = ss.SStaff_SStaff_TemporaryAddressStartDate,
                                TemporaryCity = ss.SStaff_SStaff_TemporaryCity,
                                TemporaryStateName = ss.SStaff_SStaff_TemporaryStateName,
                                TemporaryZipCode = ss.SStaff_SStaff_TemporaryZipCode,
                                TerminationDate = ss.SStaff_SStaff_TerminationDate,
                                TerminationReason = ss.SStaff_SStaff_TerminationReason,
                                VANumber = ss.SStaff_SStaff_VANumber,
                                VerifyCodeLastChangedDate = ss.SStaff_SStaff_VerifyCodeLastChangedDate,
                                VistaCreateDate = ss.SStaff_SStaff_VistaCreateDate,
                                VistaEditDate = ss.SStaff_SStaff_VistaEditDate,
                                VoicePager = ss.SStaff_SStaff_VoicePager,
                                ZipCode = ss.SStaff_SStaff_ZipCode,

                                REFERRAL = new REFERRAL
                                {
                                    COMMENT_TEXT = ss.COMMENT_TEXT,
                                    CREATED = ss.CREATED,
                                    CREATEDBY = ss.CREATEDBY,
                                    CREATEDSOURCE = ss.CREATEDSOURCE,
                                    DUPLICATE_FLAG = ss.DUPLICATE_FLAG,
                                    PATIENT_ID = ss.PATIENT_ID,
                                    PROVIDER_ID = ss.PROVIDER_ID,
                                    REFERRAL_CLASS_TEXT = ss.REFERRAL_CLASS_TEXT,
                                    REFERRAL_DATE = ss.REFERRAL_DATE,
                                    REFERRAL_ID = ss.REFERRAL_ID,
                                    REVIEW_BY = ss.REVIEW_BY,
                                    REVIEW_DATE = ss.REVIEW_DATE,
                                    STD_REFERRALSTS_ID = ss.STD_REFERRALSTS_ID,
                                    STD_REGISTRY_ID = ss.STD_REGISTRY_ID,
                                    STD_REMINDERCLASS_ID = ss.STD_REMINDERCLASS_ID,
                                    UPDATED = ss.UPDATED,
                                    UPDATEDBY = ss.UPDATEDBY,
                                    UPDATEDSOURCE = ss.UPDATEDSOURCE
                                }
                            };

                            objReturn.Add(staff);
                        }
                    }
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<SStaff_SStaff> GetItemsByName(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string LAST_NAME, string FIRST_NAME)
        {
            List<SStaff_SStaff> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_SStaff_SStaff_getitemsByName(CURRENT_USER, CURRENT_REGISTRY_ID, LAST_NAME, FIRST_NAME).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

		#endregion
	}
}
